/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public class ModifierIngredientHelper
implements IIngredientHelper<ModifierEntry> {
    public IIngredientType<ModifierEntry> getIngredientType() {
        return TConstructJEIConstants.MODIFIER_TYPE;
    }

    @Nullable
    public ModifierEntry getMatch(Iterable<ModifierEntry> iterable, ModifierEntry check, UidContext context) {
        for (ModifierEntry entry : iterable) {
            if (!entry.matches(check.getId())) continue;
            return entry;
        }
        return null;
    }

    public String getDisplayName(ModifierEntry entry) {
        return entry.getModifier().getDisplayName(entry.getLevel()).getString();
    }

    public String getUniqueId(ModifierEntry entry, UidContext context) {
        return entry.getId().toString();
    }

    @Deprecated
    public String getModId(ModifierEntry entry) {
        return entry.getId().m_135827_();
    }

    @Deprecated
    public String getResourceId(ModifierEntry entry) {
        return entry.getId().m_135815_();
    }

    public ResourceLocation getResourceLocation(ModifierEntry entry) {
        return entry.getId();
    }

    public ModifierEntry copyIngredient(ModifierEntry entry) {
        return entry;
    }

    public String getErrorInfo(@Nullable ModifierEntry entry) {
        if (entry == null) {
            return "null";
        }
        return entry.getId().toString();
    }

    public ItemStack getCheatItemStack(ModifierEntry ingredient) {
        return ModifierCrystalItem.withModifier(ingredient.getId());
    }
}

